# バッチ設計書 6-Backport Label Audit

## 概要

本ドキュメントは、JuliaLangリポジトリにおけるBackport Label Audit GitHub Actionsワークフローのバッチ設計書である。バックポートラベルの監査を行い、既にバックポート済みのPRからラベルを除去する手動実行型のワークフローである。

### 本バッチの処理概要

このバッチは、手動でトリガーされ、バックポートラベルの監査を行うワークフローである。既にバックポート済みのPRからバックポートラベルを除去することで、ラベル管理の整合性を維持する。

**業務上の目的・背景**：Juliaプロジェクトではリリースブランチへのバックポートを管理するためにラベルを使用している。PRがマージされた後、バックポート対象としてラベルが付与されるが、実際にバックポートが完了した後もラベルが残存する場合がある。この残存ラベルはバックポート管理を混乱させるため、定期的に監査を行い、不要なラベルを除去するプロセスが必要である。

**バッチの実行タイミング**：`workflow_dispatch`による手動実行。定期的なスケジュール実行ではなく、リリースマネージャーが必要に応じて手動で実行する。

**主要な処理内容**：
1. 指定されたリリースバージョン（オプション）のバックポートラベルを持つPRを検索
2. 各PRについてバックポートが完了しているかを確認
3. バックポート完了済みのPRからラベルを除去（dry_run=falseの場合）
4. dry_run=trueの場合は報告のみで変更を行わない

**前後の処理との関連**：本バッチは独立したワークフローであるが、JuliaLang/backporter-github-actions-workflowsリポジトリの監査ワークフローを再利用している。バックポートプロセス全体の管理と連携している。

**影響範囲**：バックポートラベルが付与されたPRが対象。dry_run=falseの場合、PRからラベルが除去される。pull-requests: write権限が必要。

## バッチ種別

メンテナンス処理（ラベル監査・クリーンアップ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | workflow_dispatch（手動実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリ | JuliaLang/juliaリポジトリ上で動作すること |
| 実行権限 | workflow_dispatchを実行できるリポジトリ権限を持つユーザー |
| 外部ワークフロー | JuliaLang/backporter-github-actions-workflows リポジトリのaudit.ymlが利用可能であること |

### 実行可否判定

手動でworkflow_dispatchイベントをトリガーした場合に実行される。デフォルトではdry_run=trueであり、安全にテスト実行が可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| version | String | No | 空文字列 | 監査対象のリリースバージョン（例：1.13）。空の場合は全バージョンを対象 |
| dry_run | Choice | Yes | 'true' | ドライラン実行フラグ。'true'=報告のみ、'false'=実際にラベルを除去 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PRメタデータ | GitHub API | バックポートラベルが付与されたPR一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions Log | テキスト | 監査結果のレポート（対象PR一覧、ラベル除去結果） |
| PR Labels | GitHub API | dry_run=falseの場合、バックポート済みPRからラベルを除去 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（ファイル出力なし） |
| 出力先 | GitHub Actions実行ログ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. ワークフロー入力パラメータの受信
   ├─ version: 対象リリースバージョン（オプション）
   └─ dry_run: ドライランフラグ
2. 外部ワークフロー呼び出し
   └─ JuliaLang/backporter-github-actions-workflows/.github/workflows/audit.ymlを呼び出し
      ├─ versionパラメータを渡す
      └─ dry_runパラメータを渡す
3. 監査処理（外部ワークフロー内）
   ├─ バックポートラベルを持つPRの検索
   ├─ 各PRのバックポート状態の確認
   └─ dry_run=falseの場合、完了済みPRからラベルを除去
```

### フローチャート

```mermaid
flowchart TD
    A[手動実行 workflow_dispatch] --> B[入力パラメータ取得]
    B --> C[外部ワークフロー audit.yml 呼び出し]
    C --> D[バックポートラベル付きPR検索]
    D --> E[各PRのバックポート状態確認]
    E --> F{dry_run?}
    F -->|true| G[監査レポート出力のみ]
    F -->|false| H[バックポート済みPRからラベル除去]
    H --> I[結果レポート出力]
    G --> J[ワークフロー終了]
    I --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし（GitHub API操作のみ） |

### テーブル別操作詳細

該当なし。本バッチはGitHub APIを使用してPRラベルを操作する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| workflow error | 外部ワークフロー呼び出し失敗 | backporter-github-actions-workflowsのaudit.ymlが利用不可 | 外部リポジトリの状態を確認 |
| API error | GitHub API エラー | ラベル除去のAPI呼び出し失敗 | GitHub Actionsの実行ログを確認し再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 外部ワークフロー依存 |
| リトライ間隔 | 外部ワークフロー依存 |
| リトライ対象エラー | 外部ワークフロー依存 |

### 障害時対応

ワークフロー失敗時は、GitHub Actionsの実行ログを確認し、必要に応じて再実行する。dry_run=trueで事前確認を行うことが推奨される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（GitHub API操作はトランザクション不可） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（ラベルの再付与で対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | バックポートラベル付きPR全件（バージョン指定時はその絞込み） |
| 目標処理時間 | GitHub Actionsのデフォルトタイムアウト内 |
| メモリ使用量上限 | GitHub Actionsランナーの標準上限 |

## 排他制御

手動実行のワークフローであり、同時に複数実行される可能性は低い。ただし、並行実行した場合にラベル操作が競合する可能性があるため、同時実行は避けることが望ましい。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | 入力パラメータ（version, dry_run） |
| 監査結果 | 処理完了時 | 対象PR一覧、バックポート状態、ラベル除去結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHub Actions実行ログ |

## 備考

- デフォルトではdry_run=trueが設定されており、安全にテスト実行が可能
- 実際のラベル除去を行う場合はdry_run='false'を明示的に選択する必要がある
- 外部ワークフロー（JuliaLang/backporter-github-actions-workflows）をuses句で呼び出しており、コミットハッシュ（f0cf777a492c5ff31196822a7d643a17ee0efbd1）で固定されている
- permissionsはpull-requests: writeが設定されている
- バージョンを指定しない場合は全リリースバージョンのバックポートラベルが対象となる
